<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%
	String path = request.getContextPath();
	String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort()
			+ path + "/";
%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<base href="<%=basePath%>" />
<link rel="stylesheet" type="text/css" href="<%= request.getContextPath()%>/resources/mta/css/examInfo.css" />
<script src="<%= request.getContextPath()%>/resources/js/jquery-easyui-1.4/jquery.min.js" type="text/javascript"></script>
<script src="<%= request.getContextPath()%>/resources/js/ajax-pushlet-client.js" type="text/javascript"></script>
<script type="text/javascript">
			var loginUserid='${userId}';
			var baseUrl='<%= request.getContextPath()%>';
			//计时器Id
			var timeID = '';
			$(function(){
				//设置每一秒调用一次倒计时函数
				timeID = setTimeout("count_down()",1000);
			});
			var examFlag =1;
			function userExam(){
				if(examFlag==1){
					examFlag=0;
					$.post(baseUrl + "/mta/F020/UserExam.html",{
						ksUuid : '${dataMap.uuid}'
					},function(data){
						if(data == -10){
							window.location.href = baseUrl + "/mta/F020/goExam.html?ksUuid=${dataMap.uuid}";
						}else if(data == -1){
							alert("您未报名该考试！");
						}else if(data == -2){
							alert("您的考试还未审核,请耐心等待...");
						}else if(data == -3){
							alert("您的考试已经及格了！");
						}else if(data == -4){
							alert("您的考试次数已达上限");
						}else if(data == -6){
							alert("非考试时间内禁止考试!");
						}else{
							alert("开始考试" + data + " 分钟后禁止考生参加!");
						}
					},"json");
				}else{
					alert("请勿重复点击！");
					examFlag=1;
				}
			}
			//定义倒计时函数
			function count_down(){
				var int_day, int_hour, int_minute, int_second;
				var n="#info";
				var flag = false;
				var time_distance = $(n).find("input[type='hidden']").val();
				time_distance -= 1;
				$(n).find("input[type='hidden']").val(time_distance);
				if(time_distance >= 0){
					flag = true;
					// 相减的差数换算成天数   
					int_day = Math.floor(time_distance/86400);
					time_distance -= int_day * 86400;
					// 相减的差数换算成小时
					int_hour = Math.floor(time_distance/3600);
					time_distance -= int_hour * 3600;
					//相减的差数换算成分钟   
					int_minute = Math.floor(time_distance/60);  
					time_distance -= int_minute * 60;
					// 相减的差数换算成秒数  
					int_second = Math.floor(time_distance);
					
					// 判断小时小于10时，前面加0进行占位
					if(int_hour < 10){
						int_hour = "0" + int_hour;
					} 
					//判断分钟小于10时，前面加0进行占位 
					if(int_minute < 10){
						int_minute = "0" + int_minute;
					} 
					// 判断秒数小于10时，前面加0进行占位 
					if(int_second < 10){
						int_second = "0" + int_second;
					}
					
					//显示倒计时效果
					var tmSec = int_day + '天 ' + int_hour + '时 ' + int_minute + '分 ' + int_second + '秒';
					$(n).find("#time").html("倒计时："+tmSec);
				}else{
					$(n).find("#time").html("倒计时：考试中...");
				}
				if(flag){
					timeID = setTimeout("count_down()",1000);
				}
			}
		</script>
	</head>
<body>
<div id="header">
		<c:import url="header.jsp"></c:import>
	</div>
	<input id="message" type="hidden" value="${message}"/>
	<div id="main" class="w">
			<div class="info">
				<div class="img_box l">
					<c:choose>
						<c:when test="${dataMap.pic!='' && dataMap.pic != null}">
							<img src="${dataMap.pic}" width="488" height="279" alt="${dataMap.examName}" />
						</c:when>
						<c:otherwise>
							<img src="<%= request.getContextPath()%>/resources/mta/images/kecheng.png" width="488" height="279" alt="${dataMap.examName}" />
						</c:otherwise>
					</c:choose>
				</div>
				<div class="info_box r">
					<p class="title">考试名称：${dataMap.examName}</p>
					<ul id="info">
						<input type='hidden' value='${dataMap.tmSec}'/>
						<li class="l">考试开始时间:${dataMap.ksBeginTm}</li>
						<li class="l">考试结束时间:${dataMap.ksEndTm}</li>
						<li class="l">总分：${dataMap.shijuanScore}</li>
						<li class="l">及格分：${dataMap.okrate}</li>
						<li class="l">学分：${dataMap.credit}</li>
						<li class="l time" id="time">倒计时：</li>
					</ul>
					<span class="start " onclick="userExam();">立即考试</span>
				</div>
			</div>
			<div class="main_center">
				<ul class="main_nav">
					<li class="selected l">考试须知</li>
				</ul>
				<div class="catalog">
					${dataMap.des}
				</div>
			</div>
		</div>

				
	<div id="footer" style="margin-top: 35px;">
		<c:import url="footer.jsp"></c:import>
	</div>
</body>
<script type="text/javascript">
	if($("#message").val() != ''){
		alert($("#message").val());
	}
</script>
</html>
